# Generate SQL
# Copyright 2008 by Brian C. Christensen

# 080613 - start first draft
# 081123 - added foreign key generation
# 081125 - add index & check generation

debug = 1

def Generate(project):

    text = []
    def printx(line):
        text.append(line)

    printx("create schema %s;" % project.Name.replace(' ', ''))  # remove spaces
    printx("")
    
    tables = project.GetList('RelationalTable')
    tables.sort(cmp=lambda x,y: cmp(x.Name, y.Name))
    # table definitions
    for table in tables:
        if table.InUse:
            printx("create table %s (" % table.Name)
            columns = table.GetList('RelationalColumn')
            for column in columns:
                if column.InUse:
                    printx("  %s  %s  %s," % (
                        column.Name or "",
                        column.DataType or "",
                        column.Key or "",  # was PrimaryKey
                        ))
            printx(");")
            
    printx("")
    # foreign key relationships
    for table in tables:
        if table.InUse:
            columns = table.GetList('RelationalColumn')
            columns.sort(cmp=lambda x,y: cmp(x.Seq, y.Seq))
            for column in columns:
                if column.InUse and column.RelationalReference:
                    printx("alter table %s " % table.Name)
                    printx("  add constraint fk_%d foreign key (%s) references  %s (%s)" % (
                        column.ID,  # to generate a key name
                        column.Name or "",
                        column.RelationalReference.RelationalTable.Name or "",
                        column.RelationalReference.Name or "",
                        ))
                    printx(";")

    printx("")
    # table indices
    indices = project.GetList('RelationalIndex')
    indices.sort(cmp=lambda x,y: cmp(x.ID, y.ID))
    for index in indices:
        if index.InUse:
            columns = index.GetList('RelationalIndexColumn')
            columns.sort(cmp=lambda x,y: cmp(x.Seq, y.Seq))
            names = [ c.RelationalColumn.Name for c in columns
                      if c.InUse and c.RelationalColumn ]
            printx("create %s index %s on %s with (%s);" %
                   (index.Unique or '', index.Name, index.RelationalTable.Name, ','.join(names)))

##    printx("")
##    # table checks
##    checks = project.GetList('RelationalCheck')
##    checks.sort(cmp=lambda x,y: cmp(x.ID, y.ID))
##    for check in checks:
##        if check.InUse:
##            printx("alter table %s add constraint %s check (" %
##                   (check.RelationalTable.Name, check.Name))
##            printx("%s" % (check.Check))
##            printx(");")

    return "\n".join(text)

def Do(self):
    rid = self.ReportID  # current report
    if rid == 1 :
        Data.Hint('Not for use in main report')
        return  # do nothing

    db = Data.DBObject  # will get objects from this database
    report = db.GetObject('Report',rid)

    text = Generate( report.Project )

    dlg = wx.lib.dialogs.ScrolledMessageDialog(Data.OpenReports[1], text, "Generate SQL")
    dlg.Show()

Do(self)

